import React from 'react';
import clamp from 'clamp';
import objectAssign from 'object-assign';
import Lens from './Lens';

var LensTop = function LensTop(_ref) {
    var cursorOffset = _ref.cursorOffset,
        position = _ref.position,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        smallImage = _ref.smallImage,
        style = _ref.style;

    var maxHeight = smallImage.height - cursorOffset.y * 2;
    var height = clamp(position.y - cursorOffset.y, 0, maxHeight);
    var computedStyle = {
        height: height + 'px',
        width: '100%',
        top: '0px'
    };

    return React.createElement(Lens, {
        fadeDurationInMs: fadeDurationInMs,
        isActive: isActive,
        isPositionOutside: isPositionOutside,
        style: objectAssign({}, style, computedStyle)
    });
};

export default LensTop;