import React from 'react';
import objectAssign from 'object-assign';
import clamp from 'clamp';
import Lens from './Lens';

var LensLeft = function LensLeft(_ref) {
    var cursorOffset = _ref.cursorOffset,
        position = _ref.position,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        smallImage = _ref.smallImage,
        style = _ref.style;


    var height = cursorOffset.y * 2;
    var maxHeight = smallImage.height - height;
    var maxWidth = smallImage.width - cursorOffset.x * 2;
    var width = clamp(position.x - cursorOffset.x, 0, maxWidth);
    var translateY = clamp(position.y - cursorOffset.y, 0, maxHeight);
    var computedStyle = {
        height: height + 'px',
        width: width + 'px',
        top: '0px',
        left: '0px'
    };

    return React.createElement(Lens, {
        fadeDurationInMs: fadeDurationInMs,
        isActive: isActive,
        isPositionOutside: isPositionOutside,
        style: objectAssign({}, style, computedStyle),
        translateY: translateY
    });
};

export default LensLeft;