'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRequiredIf = require('react-required-if');

var _reactRequiredIf2 = _interopRequireDefault(_reactRequiredIf);

var _reactCursorPosition = require('react-cursor-position');

var _reactCursorPosition2 = _interopRequireDefault(_reactCursorPosition);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _ImageLensShaded = require('./ImageLensShaded');

var _ImageLensShaded2 = _interopRequireDefault(_ImageLensShaded);

var _EnlargedImage = require('./EnlargedImage');

var _EnlargedImage2 = _interopRequireDefault(_EnlargedImage);

var _ImageShape = require('./ImageShape');

var _ImageShape2 = _interopRequireDefault(_ImageShape);

var _noop = require('./noop');

var _noop2 = _interopRequireDefault(_noop);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ReactImageMagnify = function (_React$Component) {
    _inherits(ReactImageMagnify, _React$Component);

    function ReactImageMagnify(props) {
        _classCallCheck(this, ReactImageMagnify);

        var _this = _possibleConstructorReturn(this, (ReactImageMagnify.__proto__ || Object.getPrototypeOf(ReactImageMagnify)).call(this, props));

        _this.state = {
            smallImageWidth: 0,
            smallImageHeight: 0,
            detectedEnvironment: {
                isMouseDeteced: false,
                isTouchDetected: false
            },
            isActive: false
        };

        _this.onSmallImageLoad = _this.onSmallImageLoad.bind(_this);
        _this.setSmallImageDimensionState = _this.setSmallImageDimensionState.bind(_this);
        _this.onDetectedEnvironmentChanged = _this.onDetectedEnvironmentChanged.bind(_this);
        _this.onActivationChanged = _this.onActivationChanged.bind(_this);
        return _this;
    }

    _createClass(ReactImageMagnify, [{
        key: 'onSmallImageLoad',
        value: function onSmallImageLoad(e) {
            var _props$smallImage$onL = this.props.smallImage.onLoad,
                onLoad = _props$smallImage$onL === undefined ? _noop2.default : _props$smallImage$onL;


            onLoad(e);

            if (!this.props.smallImage.isFluidWidth) {
                return;
            }

            this.setSmallImageDimensionState();
        }
    }, {
        key: 'setSmallImageDimensionState',
        value: function setSmallImageDimensionState() {
            var _smallImageEl = this.smallImageEl,
                smallImageWidth = _smallImageEl.offsetWidth,
                smallImageHeight = _smallImageEl.offsetHeight;


            this.setState({
                smallImageWidth: smallImageWidth,
                smallImageHeight: smallImageHeight
            });
        }
    }, {
        key: 'onDetectedEnvironmentChanged',
        value: function onDetectedEnvironmentChanged(detectedEnvironment) {
            this.setState({
                detectedEnvironment: detectedEnvironment
            });
        }
    }, {
        key: 'onActivationChanged',
        value: function onActivationChanged(_ref) {
            var isActive = _ref.isActive;

            this.setState({
                isActive: isActive
            });
        }
    }, {
        key: 'getEnlargedImagePlacement',
        value: function getEnlargedImagePlacement() {
            var enlargedImagePosition = this.props.enlargedImagePosition;
            var isTouchDetected = this.state.detectedEnvironment.isTouchDetected;


            return enlargedImagePosition || (isTouchDetected ? 'over' : 'beside');
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            if (this.props.smallImage.isFluidWidth) {
                this.setSmallImageDimensionState();
                window.addEventListener('resize', this.setSmallImageDimensionState);
            }
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            window.removeEventListener('resize', this.setSmallImageDimensionState);
        }
    }, {
        key: 'getCursorOffsetDimension',
        value: function getCursorOffsetDimension(smallImageDimension, largeImageDimension) {
            return Math.round(smallImageDimension / largeImageDimension * smallImageDimension / 2);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                className = _props.className,
                enlargedImageContainerClassName = _props.enlargedImageContainerClassName,
                enlargedImageContainerStyle = _props.enlargedImageContainerStyle,
                enlargedImageClassName = _props.enlargedImageClassName,
                enlargedImageStyle = _props.enlargedImageStyle,
                fadeDurationInMs = _props.fadeDurationInMs,
                hoverDelayInMs = _props.hoverDelayInMs,
                hoverOffDelayInMs = _props.hoverOffDelayInMs,
                isActivatedOnTouch = _props.isActivatedOnTouch,
                imageClassName = _props.imageClassName,
                imageStyle = _props.imageStyle,
                largeImage = _props.largeImage,
                lensStyle = _props.lensStyle,
                pressDuration = _props.pressDuration,
                pressMoveThreshold = _props.pressMoveThreshold,
                isSmallImageFluidWidth = _props.smallImage.isFluidWidth,
                style = _props.style;
            var _state = this.state,
                smallImageWidth = _state.smallImageWidth,
                smallImageHeight = _state.smallImageHeight,
                isTouchDetected = _state.detectedEnvironment.isTouchDetected;


            var fluidWidthSmallImage = (0, _objectAssign2.default)({}, this.props.smallImage, {
                width: smallImageWidth,
                height: smallImageHeight
            });
            var fixedWidthSmallImage = this.props.smallImage;
            var smallImage = isSmallImageFluidWidth ? fluidWidthSmallImage : fixedWidthSmallImage;

            var cursorOffset = {
                x: this.getCursorOffsetDimension(smallImage.width, largeImage.width),
                y: this.getCursorOffsetDimension(smallImage.height, largeImage.height)
            };

            var fluidWidthContainerStyle = {
                width: 'auto',
                height: 'auto',
                fontSize: '0px',
                position: 'relative'
            };
            var fixedWidthContainerStyle = {
                width: smallImage.width + 'px',
                height: smallImage.height + 'px',
                position: 'relative'
            };
            var priorityContainerStyle = isSmallImageFluidWidth ? fluidWidthContainerStyle : fixedWidthContainerStyle;
            var compositContainerStyle = (0, _objectAssign2.default)({
                cursor: 'crosshair'
            }, style, priorityContainerStyle);

            var fluidWidthSmallImageStyle = {
                width: '100%',
                height: 'auto',
                display: 'block',
                pointerEvents: 'none'
            };
            var fixedWidthSmallImageStyle = {
                width: smallImage.width + 'px',
                height: smallImage.height + 'px',
                pointerEvents: 'none'
            };
            var prioritySmallImageStyle = isSmallImageFluidWidth ? fluidWidthSmallImageStyle : fixedWidthSmallImageStyle;
            var compositSmallImageStyle = (0, _objectAssign2.default)({}, imageStyle, prioritySmallImageStyle);
            var enlargedImagePlacement = this.getEnlargedImagePlacement();
            var shouldShowLens = enlargedImagePlacement !== 'over' && !isTouchDetected;

            return _react2.default.createElement(
                _reactCursorPosition2.default,
                {
                    className: className,
                    hoverDelayInMs: hoverDelayInMs,
                    hoverOffDelayInMs: hoverOffDelayInMs,
                    isActivatedOnTouch: isActivatedOnTouch,
                    onActivationChanged: this.onActivationChanged,
                    onDetectedEnvironmentChanged: this.onDetectedEnvironmentChanged,
                    pressDuration: pressDuration,
                    pressMoveThreshold: pressMoveThreshold,
                    style: compositContainerStyle
                },
                _react2.default.createElement('img', {
                    src: smallImage.src,
                    srcSet: smallImage.srcSet,
                    sizes: smallImage.sizes,
                    alt: smallImage.alt,
                    className: imageClassName,
                    style: compositSmallImageStyle,
                    ref: function ref(el) {
                        return _this2.smallImageEl = el;
                    },
                    onLoad: this.onSmallImageLoad
                }),
                shouldShowLens && _react2.default.createElement(_ImageLensShaded2.default, {
                    cursorOffset: cursorOffset,
                    fadeDurationInMs: fadeDurationInMs,
                    smallImage: smallImage,
                    style: lensStyle
                }),
                _react2.default.createElement(_EnlargedImage2.default, {
                    containerClassName: enlargedImageContainerClassName,
                    containerStyle: enlargedImageContainerStyle,
                    cursorOffset: cursorOffset,
                    fadeDurationInMs: fadeDurationInMs,
                    imageClassName: enlargedImageClassName,
                    imageStyle: enlargedImageStyle,
                    imagePosition: enlargedImagePlacement,
                    largeImage: largeImage,
                    smallImage: smallImage
                })
            );
        }
    }]);

    return ReactImageMagnify;
}(_react2.default.Component);

ReactImageMagnify.propTypes = {
    className: _propTypes2.default.string,
    enlargedImageContainerClassName: _propTypes2.default.string,
    enlargedImageContainerStyle: _propTypes2.default.object,
    enlargedImageClassName: _propTypes2.default.string,
    enlargedImageStyle: _propTypes2.default.object,
    fadeDurationInMs: _propTypes2.default.number,
    hoverDelayInMs: _propTypes2.default.number,
    hoverOffDelayInMs: _propTypes2.default.number,
    isActivatedOnTouch: _propTypes2.default.bool,
    imageClassName: _propTypes2.default.string,
    imageStyle: _propTypes2.default.object,
    largeImage: _ImageShape2.default,
    lensStyle: _propTypes2.default.object,
    pressDuration: _propTypes2.default.number,
    pressMoveThreshold: _propTypes2.default.number,
    smallImage: _propTypes2.default.shape({
        alt: _propTypes2.default.string,
        isFluidWidth: _propTypes2.default.bool,
        src: _propTypes2.default.string.isRequired,
        srcSet: _propTypes2.default.string,
        sizes: _propTypes2.default.string,
        width: (0, _reactRequiredIf2.default)(_propTypes2.default.number, function (props) {
            return !props.isFluidWidth;
        }),
        height: (0, _reactRequiredIf2.default)(_propTypes2.default.number, function (props) {
            return !props.isFluidWidth;
        }),
        onLoad: _propTypes2.default.func
    }),
    style: _propTypes2.default.object,
    enlargedImagePosition: _propTypes2.default.oneOf(['beside', 'over'])
};
ReactImageMagnify.defaultProps = {
    fadeDurationInMs: 300,
    hoverDelayInMs: 250,
    hoverOffDelayInMs: 150
};
exports.default = ReactImageMagnify;