'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _clamp = require('clamp');

var _clamp2 = _interopRequireDefault(_clamp);

var _Lens = require('./Lens');

var _Lens2 = _interopRequireDefault(_Lens);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LensBottom = function LensBottom(_ref) {
    var cursorOffset = _ref.cursorOffset,
        position = _ref.position,
        fadeDurationInMs = _ref.fadeDurationInMs,
        isActive = _ref.isActive,
        isPositionOutside = _ref.isPositionOutside,
        smallImage = _ref.smallImage,
        style = _ref.style;


    var maxHeight = smallImage.height - cursorOffset.y * 2;
    var height = (0, _clamp2.default)(smallImage.height - position.y - cursorOffset.y, 0, maxHeight);
    var top = Math.max(position.y + cursorOffset.y, cursorOffset.y * 2);
    var computedStyle = {
        height: height + 'px',
        width: '100%',
        top: top
    };

    return _react2.default.createElement(_Lens2.default, {
        fadeDurationInMs: fadeDurationInMs,
        isActive: isActive,
        isPositionOutside: isPositionOutside,
        style: (0, _objectAssign2.default)({}, style, computedStyle)
    });
};

exports.default = LensBottom;