'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _clamp = require('clamp');

var _clamp2 = _interopRequireDefault(_clamp);

var _ImageShape = require('./ImageShape');

var _ImageShape2 = _interopRequireDefault(_ImageShape);

var _Point = require('./Point');

var _Point2 = _interopRequireDefault(_Point);

var _noop = require('./noop');

var _noop2 = _interopRequireDefault(_noop);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _class = function (_React$Component) {
    _inherits(_class, _React$Component);

    function _class(props) {
        _classCallCheck(this, _class);

        var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this, props));

        _this.state = {
            isTransitionEntering: false,
            isTransitionActive: false,
            isTransitionLeaving: false,
            isTransitionDone: false
        };

        _this.timers = [];
        return _this;
    }

    _createClass(_class, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            var _this2 = this;

            var _props = this.props,
                fadeDurationInMs = _props.fadeDurationInMs,
                isActive = _props.isActive,
                isPositionOutside = _props.isPositionOutside;


            if (isActive === nextProps.isActive && isPositionOutside === nextProps.isPositionOutside) {
                return;
            }

            if (nextProps.isActive && !nextProps.isPositionOutside) {
                this.setState({
                    isTrainsitionDone: false,
                    isTransitionEntering: true
                });

                this.timers.push(setTimeout(function () {
                    _this2.setState({
                        isTransitionEntering: false,
                        isTransitionActive: true
                    });
                }, 0));
            } else {
                this.setState({
                    isTransitionLeaving: true,
                    isTransitionActive: false
                });

                this.timers.push(setTimeout(function () {
                    _this2.setState({
                        isTransitionDone: true,
                        isTransitionLeaving: false
                    });
                }, fadeDurationInMs));
            }
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            this.timers.forEach(function (timerId) {
                clearTimeout(timerId);
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                containerClassName = _props2.containerClassName,
                containerStyle = _props2.containerStyle,
                cursorOffset = _props2.cursorOffset,
                position = _props2.position,
                fadeDurationInMs = _props2.fadeDurationInMs,
                imageClassName = _props2.imageClassName,
                imageStyle = _props2.imageStyle,
                isLazyLoaded = _props2.isLazyLoaded,
                largeImage = _props2.largeImage,
                _props2$largeImage$on = _props2.largeImage.onLoad,
                onLoad = _props2$largeImage$on === undefined ? _noop2.default : _props2$largeImage$on,
                smallImage = _props2.smallImage,
                imagePosition = _props2.imagePosition;
            var _state = this.state,
                isTransitionEntering = _state.isTransitionEntering,
                isTransitionActive = _state.isTransitionActive,
                isTransitionLeaving = _state.isTransitionLeaving;


            var offsetRatio = {
                x: largeImage.width / smallImage.width,
                y: largeImage.height / smallImage.height
            };

            var differentiatedImageCoordinates = {
                x: Math.round((position.x - cursorOffset.x) * offsetRatio.x) * -1,
                y: Math.round((position.y - cursorOffset.y) * offsetRatio.y) * -1
            };

            var minCoordinates = {
                x: (largeImage.width - smallImage.width) * -1,
                y: (largeImage.height - smallImage.height) * -1
            };

            var maxCoordinate = 0;

            var imageCoordinates = {
                x: (0, _clamp2.default)(differentiatedImageCoordinates.x, minCoordinates.x, maxCoordinate),
                y: (0, _clamp2.default)(differentiatedImageCoordinates.y, minCoordinates.y, maxCoordinate)
            };

            var isVisible = void 0;
            if (isTransitionEntering || isTransitionActive || isTransitionLeaving) {
                isVisible = true;
            } else {
                isVisible = false;
            }

            var defaultContainerStyle = {
                position: 'absolute',
                top: '0px',
                overflow: 'hidden'
            };

            switch (imagePosition) {
                case 'over':
                    defaultContainerStyle = (0, _objectAssign2.default)({}, defaultContainerStyle, {
                        left: '0px'
                    });
                    break;
                case 'beside':
                default:
                    defaultContainerStyle = (0, _objectAssign2.default)({}, defaultContainerStyle, {
                        left: '100%',
                        marginLeft: '10px',
                        border: '1px solid #d6d6d6'
                    });
                    break;
            }

            var computedContainerStyle = {
                width: smallImage.width,
                height: smallImage.height,
                opacity: this.state.isTransitionActive ? 1 : 0,
                transition: 'opacity ' + fadeDurationInMs + 'ms ease-in',
                pointerEvents: 'none'
            };

            var translate = 'translate(' + imageCoordinates.x + 'px, ' + imageCoordinates.y + 'px)';

            var computedImageStyle = {
                width: largeImage.width,
                height: largeImage.height,
                transform: translate,
                WebkitTransform: translate,
                msTransform: translate,
                pointerEvents: 'none'
            };

            var component = _react2.default.createElement(
                'div',
                {
                    className: containerClassName,
                    style: (0, _objectAssign2.default)({}, defaultContainerStyle, containerStyle, computedContainerStyle)
                },
                _react2.default.createElement('img', {
                    alt: largeImage.alt,
                    className: imageClassName,
                    src: largeImage.src,
                    srcSet: largeImage.srcSet,
                    sizes: largeImage.sizes,
                    style: (0, _objectAssign2.default)({}, imageStyle, computedImageStyle),
                    onLoad: onLoad
                })
            );

            if (isLazyLoaded) {
                return isVisible ? component : null;
            }

            return component;
        }
    }]);

    return _class;
}(_react2.default.Component);

_class.displayName = 'EnlargedImage';
_class.defaultProps = {
    fadeDurationInMs: 0,
    isLazyLoaded: true
};
_class.propTypes = {
    containerClassName: _propTypes2.default.string,
    containerStyle: _propTypes2.default.object,
    cursorOffset: _Point2.default,
    position: _Point2.default,
    fadeDurationInMs: _propTypes2.default.number,
    imageClassName: _propTypes2.default.string,
    imageStyle: _propTypes2.default.object,
    isActive: _propTypes2.default.bool,
    isLazyLoaded: _propTypes2.default.bool,
    largeImage: _ImageShape2.default,
    smallImage: _ImageShape2.default,
    imagePosition: _propTypes2.default.oneOf(['beside', 'over'])
};
exports.default = _class;