import React from 'react';
import { alpha, useMediaQuery, useTheme } from "@mui/material";

const StoreMessageSvg = () => {
    const theme = useTheme()
    const isSmall = useMediaQuery(theme.breakpoints.down("sm"));
    return (
        // <svg width="100%" height="74"  viewBox="0 0 100% 74" fill="none" xmlns="http://www.w3.org/2000/svg">
        //     <rect x="0.5" y="6.79297" width="100%" height="59" rx="9.5" fill={alpha(theme.palette.primary.main,.2)} stroke={alpha(theme.palette.primary.main,.2)}/>
        //     <path d="M106.994 65.0574L105.493 65.9313C104.341 66.6001 102.9 66.465 101.885 65.5937L92.2622 57.4006L104.25 55.5425L107.896 60.3055C109.068 61.855 108.653 64.0907 106.994 65.0574ZM75.9991 39.3342L72.5142 41.3735C70.2552 42.6989 69.4791 45.64 70.8055 47.944L75.61 56.3468C76.9247 58.6529 79.8268 59.4535 82.097 58.124L85.5851 56.0965L75.9991 39.3342ZM118.362 47.5032L99.7632 14.9732C99.204 13.9943 97.8561 13.8828 97.1624 14.7558L79.0606 37.556L88.6422 54.3126L117.248 49.8837C118.344 49.7142 118.922 48.4792 118.362 47.5032ZM111.995 18.1451C111.735 18.2148 111.456 18.2177 111.178 18.1409C110.333 17.9082 109.829 17.026 110.052 16.1715L111.217 11.6965C111.438 10.8404 112.306 10.3361 113.148 10.5704C113.993 10.8031 114.497 11.6853 114.275 12.5398L113.11 17.0148C112.96 17.5887 112.521 18.0041 111.995 18.1451ZM117.068 28.3639C116.394 28.5445 115.655 28.2523 115.287 27.6085C114.848 26.839 115.103 25.8594 115.857 25.4185L119.806 23.1171C120.565 22.6768 121.529 22.9427 121.97 23.7135C122.409 24.483 122.154 25.4626 121.4 25.9035L117.451 28.205C117.326 28.2772 117.199 28.3288 117.068 28.3639ZM127.717 39.1285C127.457 39.1982 127.178 39.2011 126.9 39.1242L122.48 37.9045C121.635 37.6718 121.131 36.7896 121.354 35.9351C121.576 35.0788 122.443 34.5747 123.285 34.809L127.705 36.0287C128.55 36.2614 129.054 37.1436 128.831 37.9981C128.683 38.5718 128.243 38.9875 127.717 39.1285Z" fill={theme.palette.primary.main} fillOpacity="0.1"/>
        //     <path d="M1208.15 7.63722L1209.36 6.9422C1210.29 6.41026 1211.44 6.51209 1212.25 7.19669L1219.93 13.6337L1210.32 15.1409L1207.42 11.3923C1206.48 10.1727 1206.82 8.40611 1208.15 7.63722ZM1232.9 27.8444L1235.7 26.2226C1237.51 25.1685 1238.15 22.8436 1237.09 21.0289L1233.27 14.4102C1232.22 12.5936 1229.9 11.9712 1228.08 13.0286L1225.28 14.6411L1232.9 27.8444ZM1198.99 21.5359L1213.78 47.1591C1214.22 47.9302 1215.3 48.0137 1215.86 47.3221L1230.44 29.2588L1222.82 16.0599L1199.89 19.6526C1199.01 19.79 1198.54 20.7671 1198.99 21.5359ZM1203.99 44.6955C1204.2 44.6396 1204.42 44.6364 1204.65 44.6961C1205.32 44.877 1205.72 45.5719 1205.54 46.2474L1204.59 49.7846C1204.41 50.4613 1203.72 50.8624 1203.04 50.6802C1202.37 50.4994 1201.96 49.8044 1202.15 49.129L1203.09 45.5917C1203.22 45.1381 1203.57 44.8086 1203.99 44.6955ZM1199.96 36.6438C1200.5 36.4989 1201.09 36.7272 1201.39 37.2343C1201.73 37.8404 1201.53 38.6147 1200.92 38.9654L1197.75 40.7958C1197.14 41.1459 1196.37 40.9392 1196.02 40.332C1195.67 39.7259 1195.88 38.9516 1196.48 38.601L1199.65 36.7705C1199.75 36.7131 1199.86 36.6719 1199.96 36.6438ZM1191.47 28.1797C1191.67 28.1238 1191.9 28.1206 1192.12 28.1804L1195.66 29.1287C1196.33 29.3096 1196.73 30.0045 1196.55 30.6799C1196.37 31.3568 1195.68 31.7577 1195 31.5755L1191.46 30.6272C1190.79 30.4463 1190.39 29.7514 1190.57 29.076C1190.69 28.6225 1191.04 28.2928 1191.47 28.1797Z" fill={theme.palette.primary.main} fillOpacity="0.1"/>
        // </svg>
        <svg width="1240" height="60" viewBox="0 0 1240 60" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect width="1240" height="60" rx="10" fill={theme.palette.primary.main} fillOpacity="0.04" />
            <rect x="0.5" y="0.5" width="1239" height="59" rx="9.5" stroke={theme.palette.primary.main} strokeOpacity="0.4" />
            <g clipPath="url(#clip0_2316_5996)">
                <path d="M106.994 58.7645L105.493 59.6383C104.341 60.3071 102.9 60.1721 101.885 59.3007L92.2622 51.1077L104.25 49.2496L107.896 54.0126C109.068 55.562 108.653 57.7977 106.994 58.7645ZM75.9991 33.0413L72.5142 35.0805C70.2552 36.406 69.4791 39.3471 70.8055 41.651L75.61 50.0538C76.9247 52.36 79.8268 53.1605 82.097 51.8311L85.5851 49.8036L75.9991 33.0413ZM118.362 41.2102L99.7632 8.68028C99.204 7.70132 97.8561 7.58982 97.1624 8.46287L79.0606 31.263L88.6422 48.0197L117.248 43.5907C118.344 43.4212 118.922 42.1862 118.362 41.2102ZM111.995 11.8522C111.735 11.9218 111.456 11.9247 111.178 11.8479C110.333 11.6152 109.829 10.733 110.052 9.87849L111.217 5.40356C111.438 4.54748 112.306 4.04315 113.148 4.27745C113.993 4.51013 114.497 5.39234 114.275 6.24685L113.11 10.7218C112.96 11.2957 112.521 11.7112 111.995 11.8522ZM117.068 22.0709C116.394 22.2515 115.655 21.9594 115.287 21.3155C114.848 20.5461 115.103 19.5664 115.857 19.1256L119.806 16.8241C120.565 16.3839 121.529 16.6498 121.97 17.4206C122.409 18.19 122.154 19.1697 121.4 19.6105L117.451 21.912C117.326 21.9842 117.199 22.0359 117.068 22.0709ZM127.717 32.8355C127.457 32.9052 127.178 32.9081 126.9 32.8313L122.48 31.6115C121.635 31.3789 121.131 30.4967 121.354 29.6421C121.576 28.7858 122.443 28.2817 123.285 28.516L127.705 29.7358C128.55 29.9684 129.054 30.8506 128.831 31.7052C128.683 32.2788 128.243 32.6945 127.717 32.8355Z" fill={theme.palette.primary.main} fillOpacity="0.2" />
            </g>
            <g clipPath="url(#clip1_2316_5996)">
                <g clipPath="url(#clip2_2316_5996)">
                    <path d="M1208.15 1.34425L1209.36 0.649227C1210.29 0.117293 1211.44 0.219124 1212.25 0.903726L1219.93 7.34075L1210.32 8.84795L1207.42 5.0993C1206.48 3.87978 1206.82 2.11315 1208.15 1.34425ZM1232.9 21.5515L1235.7 19.9296C1237.51 18.8755 1238.15 16.5507 1237.09 14.7359L1233.27 8.11719C1232.22 6.30068 1229.9 5.67828 1228.08 6.73559L1225.28 8.34814L1232.9 21.5515ZM1198.99 15.2429L1213.78 40.8661C1214.22 41.6372 1215.3 41.7208 1215.86 41.0291L1230.44 22.9658L1222.82 9.7669L1199.89 13.3596C1199.01 13.497 1198.54 14.4741 1198.99 15.2429ZM1203.99 38.4025C1204.2 38.3466 1204.42 38.3434 1204.65 38.4031C1205.32 38.584 1205.72 39.2789 1205.54 39.9544L1204.59 43.4917C1204.41 44.1684 1203.72 44.5695 1203.04 44.3873C1202.37 44.2064 1201.96 43.5115 1202.15 42.836L1203.09 39.2988C1203.22 38.8451 1203.57 38.5156 1203.99 38.4025ZM1199.96 30.3508C1200.5 30.2059 1201.09 30.4342 1201.39 30.9413C1201.73 31.5474 1201.53 32.3218 1200.92 32.6724L1197.75 34.5028C1197.14 34.8529 1196.37 34.6462 1196.02 34.0391C1195.67 33.433 1195.88 32.6586 1196.48 32.308L1199.65 30.4776C1199.75 30.4201 1199.86 30.3789 1199.96 30.3508ZM1191.47 21.8868C1191.67 21.8309 1191.9 21.8277 1192.12 21.8874L1195.66 22.8357C1196.33 23.0166 1196.73 23.7115 1196.55 24.387C1196.37 25.0638 1195.68 25.4648 1195 25.2826L1191.46 24.3343C1190.79 24.1534 1190.39 23.4585 1190.57 22.783C1190.69 22.3295 1191.04 21.9999 1191.47 21.8868Z" fill={theme.palette.primary.main} fillOpacity="0.2" />
                </g>
            </g>
            <defs>
                <clipPath id="clip0_2316_5996">
                    <rect width="59" height="60" fill="white" transform="translate(63 13.1562) rotate(-15)" />
                </clipPath>
                <clipPath id="clip1_2316_5996">
                    <rect x="1185" width="55" height="55" rx="10" fill="white" />
                </clipPath>
                <clipPath id="clip2_2316_5996">
                    <rect width="47.3218" height="47.3218" fill="white" transform="translate(1243.25 37.207) rotate(165)" />
                </clipPath>
            </defs>
        </svg>



    );
};

export default StoreMessageSvg;